﻿//DESCRIPTION Text von unnützen Leerräumen bereinigen
/*
@Version: 1.0
@Date: 2014-04-14
*/
#target InDesign

main();

function main() {
	// Versionsprüfung 
	if (app.scriptPreferences.version < 5) {
		alert ("Für dieses Skript wird mindestens InDesign CS3 benötigt.");
		return;	
	}
	// Auswahlprüfung
	if (app.selection.length == 0 || !app.selection[0].hasOwnProperty ("changeGrep")) {
		alert ("Bitte wählen Sie einen Textbereich oder Textrahmen aus");
		return;	
	}
	// Bei Auswahl des Cursors den gesamten Text auswählen 
	if (app.selection[0].constructor.name == "InsertionPoint") {
		app.select(SelectAll.ALL);
	}

	var replaceObject = app.selection[0];
	// Prüfung ob die Auswahl Text enthält
	if (!objectHasText (replaceObject)) {
		alert ("Die Auswahl enthält keine Buchstaben");
		return;
	}

	// Such-Einstellungen zurücksetzen
	app.findGrepPreferences = NothingEnum.NOTHING;
	app.changeGrepPreferences = NothingEnum.NOTHING;
	
	cleanHorizontalSpace(replaceObject);

	// Abfrage mit Hilfe eine einfachen Dialogs
	var result = confirm("Wollen Sie mehrfache Zeilenumbrüche zu einem zusammenführen?");
	
	if (result) {
		cleanVerticalSpace(replaceObject);
	}

	// Such-Einstellungen zurücksetzen
	app.findGrepPreferences = NothingEnum.NOTHING;
	app.changeGrepPreferences = NothingEnum.NOTHING;
}

function cleanHorizontalSpace(replaceObject) {
	var currentSelection = app.selection[0];
	// Mehrfache Leerzeichen löschen
	app.findGrepPreferences.findWhat = "(?<= ) +";
	app.changeGrepPreferences.changeTo = "";
	if (objectHasText(replaceObject)) replaceObject.changeGrep();
	else return;
	// Leerzeichen am Zeilenende löschen
	app.findGrepPreferences.findWhat = " +$";
	if (objectHasText(replaceObject)) replaceObject.changeGrep();
	else return;
	// Leerzeichen am Zeilenanfang löschen
	app.findGrepPreferences.findWhat = "^ +";
	if (objectHasText(replaceObject)) replaceObject.changeGrep();
	else return;
	// Mehrfach gesetzte Tabulatoren löschen
	app.findGrepPreferences.findWhat = "(?<=\\t)\\t+";
	if (objectHasText(replaceObject)) replaceObject.changeGrep();
	else return;
}

function cleanVerticalSpace(replaceObject ) {
	// Mehrfache Zeilenumbrüche löschen
	app.findGrepPreferences.findWhat = "(?<=\\r)\\r+";
	app.changeGrepPreferences.changeTo = "";
	if (objectHasText(replaceObject)) replaceObject.changeGrep();
	else return;
}

function objectHasText (object) {
	if (!object.hasOwnProperty ("characters")) {
		return false;
	}  
	if (object.characters.length == 0) {
		return false;
	}
	return true;
}